//------------------------
// PARAMETERS

float4x4 gWorldViewProjMatrix
<
   string paramClass="intrinsic";
   string paramName="worldViewProj";
> = float4x4(1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1);

float4 gEmissiveColor
<
   string paramClass="param";
   string paramName="emissiveColor";
   string paramType="color";
   bool linearColor=true;
> = float4(0, 0, 0, 0);

float gRGBScale
<
   string paramClass="intrinsic";
   string paramName="RGBScale";
   string paramType="float";
> = 1.0;

sampler tx0 : register(s0);

// END PARAMETERS


//------------------------
// FUNCTION_VS EmissiveVS

uniform mat4 gWorldViewProjMatrix;

void main()
{
	// Transform position
	gl_Position = gl_Vertex * gWorldViewProjMatrix;
	
	// Output tex coords
    gl_TexCoord[0].st = gl_MultiTexCoord0.st;
}


//----------------------------
// FUNCTION_VS EmissiveCubeVS

uniform mat4 gWorldViewProjMatrix;

void main()
{
   // Transform position
	gl_Position = gl_Vertex * gWorldViewProjMatrix;
   
   // Output tex coords
    gl_TexCoord[0].xyz = gl_MultiTexCoord0.xyz;
}


//------------------------
// FUNCTION_PS EmissivePS

uniform sampler2D tx0;	// diffuse texture

uniform vec4 gEmissiveColor;
uniform float gRGBScale;

void main()
{
	vec4 texColor = texture2D(tx0, gl_TexCoord[0].st);
	texColor.rgb *= texColor.rgb;
	
	gl_FragColor = gEmissiveColor * texColor;
#ifdef SCALERGBOUTPUT
	gl_FragColor.rgb *= gRGBScale;
#endif
}


//----------------------------
// FUNCTION_PS EmissiveCubePS

uniform samplerCube tx0;	// cube texture

uniform vec4 gEmissiveColor;
uniform float gRGBScale;

void main()
{
   vec4 texColor = textureCube(tx0, gl_TexCoord[0].xyz);
   texColor.rgb *= texColor.rgb;
   
   gl_FragColor = gEmissiveColor * texColor;
#ifdef SCALERGBOUTPUT
   gl_FragColor.rgb *= gRGBScale;
#endif
}
